/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;

public class CommandPruneWorld
implements IMCOPCommand {
    private static final String RADIUS_ARG = "additional block protection radius";
    private static final String COMMAND_STAGE = "stage";
    private static final String REGION_FOLDER = "region";

    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        return this.tryPrune(context, 0);
    }

    private int executeWithPage(CommandContext<CommandSource> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        return this.tryPrune(context, IntegerArgumentType.getInteger(context, (String)COMMAND_STAGE));
    }

    private int tryPrune(CommandContext<CommandSource> context, int arg) {
        if (arg < 3) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("com.minecolonies.command.prune.next", new Object[]{arg + 1}), true);
            return 0;
        }
        int radius = IntegerArgumentType.getInteger(context, (String)RADIUS_ARG);
        int deleteCount = 0;
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        File saveDir = new File(DimensionType.func_236031_a_((RegistryKey)world.func_234923_W_(), (File)world.func_73046_m().func_240776_a_(FolderName.field_237253_i_).toFile()), REGION_FOLDER);
        ArrayList<IColony> colonies = new ArrayList();
        IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).orElseGet(null);
        if (cap == null) {
            return 0;
        }
        colonies = cap.getColonies();
        for (File currentRegion : saveDir.listFiles()) {
            int regionZ;
            int regionX;
            String[] split;
            if (currentRegion == null || !currentRegion.getName().contains(".mca") || (split = currentRegion.getName().split("\\.")).length != 4 || !this.isFarEnoughFromColonies(regionX = Integer.parseInt(split[1]), regionZ = Integer.parseInt(split[2]), radius, colonies)) continue;
            if (!currentRegion.delete()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Could not delete file:" + currentRegion.getPath()), true);
                continue;
            }
            ++deleteCount;
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Deleted file:" + currentRegion.getPath()), true);
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Successfully deleted " + deleteCount + " regions!"), true);
        return 0;
    }

    private boolean isFarEnoughFromColonies(int regionX, int regionZ, int blockRadius, List<IColony> colonies) {
        for (IColony colony : colonies) {
            for (BlockPos buildingPos : colony.getBuildingManager().getBuildings().keySet()) {
                int maxX = buildingPos.func_177958_n() + blockRadius >> 9;
                int minX = buildingPos.func_177958_n() - blockRadius >> 9;
                int maxZ = buildingPos.func_177952_p() + blockRadius >> 9;
                int minZ = buildingPos.func_177952_p() - blockRadius >> 9;
                if (regionX > maxX || regionX < minX || regionZ > maxZ || regionZ < minZ) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "prune-world-now";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument(COMMAND_STAGE, IntegerArgumentType.integer((int)1)).executes(this::executeWithPage)).then(IMCCommand.newArgument(RADIUS_ARG, IntegerArgumentType.integer((int)100, (int)5000)).executes(this::executeWithPage)))).executes(this::checkPreConditionAndExecute);
    }
}

